﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Settings
{
    public partial class TableSettings : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
                LoadTableDetails();
        }

        protected void btnSaveTableSetting_Click(object sender, EventArgs e)
        {
            if (ValidateTableSettings(txtTableName, txtTableCapacity))
            {
                Layouts NewTable = new Layouts();
                NewTable.IsActive = true;
                NewTable.CreatedBy = WebSession.CurrentAdminUser != null && WebSession.CurrentAdminUser.UniqueID != Guid.Empty ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty;
                NewTable.TableName = txtTableName.Text.Trim();
                NewTable.TableCapacity = string.IsNullOrEmpty(txtTableCapacity.Text)?0:int.Parse(txtTableCapacity.Text.Trim());
                LayoutBL.Save(NewTable);
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ShowAlert('Table saved successfully','Ei8htPOS')", true);
                LoadTableDetails();
            }
        }

        protected void gvTables_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            gvTables.EditIndex = -1;
            LoadTableDetails();
        }

        private void LoadTableDetails()
        {
            List<Layouts> Tables = LayoutBL.GetList(Guid.Empty);
            if (Tables != null && Tables.Count > 0)
            {
                Tables = Tables.Where(a => a.IsActive).ToList<Layouts>();
            }
            gvTables.DataSource = Tables;
            gvTables.DataBind();
            txtTableName.Text = txtTableCapacity.Text= string.Empty;
            
        }

        protected void gvTables_RowEditing(object sender, GridViewEditEventArgs e)
        {
            gvTables.EditIndex = e.NewEditIndex;
            LoadTableDetails();
        }

        protected void gvTables_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            Guid TableID = Guid.Parse(gvTables.DataKeys[e.RowIndex].Value.ToString());
            btnDeleteTable.Attributes["data-TaxID"] = TableID.ToString();
            LoadTableDetails();
            ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ConfirmDelete();", true);
        }

        protected void gvTables_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            Guid TableID = Guid.Parse(gvTables.DataKeys[e.RowIndex].Value.ToString());
            GridViewRow row = (GridViewRow)gvTables.Rows[e.RowIndex];

            TextBox txtNameEdit = (TextBox)row.Cells[1].FindControl("txtNameEdit");
            TextBox txtCapacity = (TextBox)row.Cells[2].FindControl("txtTableCapacityEdit");

            if (ValidateTableSettings(txtNameEdit, txtCapacity))
            {
                Layouts NewTable = new Layouts();
                NewTable.TableID = TableID;
                NewTable.TableName = txtNameEdit.Text.Trim();
                NewTable.TableCapacity = int.Parse(txtCapacity.Text.Trim());
                NewTable.IsActive = true;
                NewTable.CreatedBy = WebSession.CurrentAdminUser != null && WebSession.CurrentAdminUser.UniqueID != Guid.Empty ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty;
                NewTable.TablePosition = "0,0";
                NewTable.TableType = "Sofa";
                LayoutBL.Save(NewTable);
                gvTables.EditIndex = -1;
                LoadTableDetails();
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ShowAlert('Tax Updated successfully','Ei8htPOS')", true);
            }
        }

        protected void btnDeleteTable_Click(object sender, EventArgs e)
        {
            Guid TableDelete = Guid.Parse(btnDeleteTable.Attributes["data-TaxID"].ToString());
            if (LayoutBL.Delete(TableDelete))
            {
                LoadTableDetails();
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ShowAlert('Table removed successfully','Ei8htPOS')", true);
            }
        }

        private bool ValidateTableSettings(TextBox TableName, TextBox TableCapacity)
        {
            if (string.IsNullOrEmpty(TableName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgTop('#" + TableName.ClientID + "', 'Please enter a Table Name.'); ", true);
                return false;
            }
            if (!string.IsNullOrEmpty(TableCapacity.Text.Trim()) && !ValidationUtility.ValidateInt(TableCapacity.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgTop('#" + TableCapacity.ClientID + "', 'Please enter a valid number in Table capacity.'); ", true);
                return false;
            }

            return true;
        }
    }
}